using System;
using System.Text;
using System.Data;
using System.Net;
using System.Globalization;

namespace gov.va.med.vbecs.Common
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Stas Antropov</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>05/18/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// StNullConvert class - all static methods
	/// </summary>
	#endregion

	#region StNullConvert Class

	public abstract class StNullConvert
	{

		#region Variables/Constants

		/// <summary>
		/// Int32.MinValue
		/// </summary>
		public const Int32 Int32Null = Int32.MinValue;

		/// <summary>
		/// Int32.MinValue + 1
		/// </summary>
		public static readonly Int32 Int32MinValue = Int32.MinValue + 1;

		/// <summary>
		/// Int32.MaxValue
		/// </summary>
		public static readonly Int32 Int32MaxValue = Int32.MaxValue;

		/// <summary>
		/// DateTime.MinValue
		/// </summary>
		public static readonly DateTime DateTimeNull = DateTime.MinValue;

		/// <summary>
		/// Char.MinValue
		/// </summary>
		public const Char CharNull = Char.MinValue;

		/// <summary>
		/// Byte.MaxValue
		/// </summary>
		public const Byte ByteNull = Byte.MaxValue;

		/// <summary>
		/// Byte.MinValue
		/// </summary>
		public static readonly byte ByteMinValue = Byte.MinValue;

		/// <summary>
		/// Byte.MaxValue - 1
		/// </summary>
		public static readonly byte ByteMaxValue = Byte.MaxValue - 1;

		/// <summary>
		/// Null GUID.
		/// </summary>
		public static readonly Guid GuidNull = Guid.Empty;

		/// <summary>
		/// Null rowversion.
		/// </summary>
		public static byte[] RowversionNull = null;

		#endregion

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="611"> 
		///		<ExpectedInput>Null values</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="612"> 
		///		<ExpectedInput>non null values</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsNull
		/// </summary>
		/// <param name="valueToCheck"></param>
		/// <returns></returns>
		public static bool IsNull( object valueToCheck )
		{
			if( ( valueToCheck == null ) || Convert.IsDBNull( valueToCheck ) )
				return true;

			if( valueToCheck is Int32 )
				return IsNull( (Int32)valueToCheck );

			if( valueToCheck is DateTime )
				return IsNull( (DateTime)valueToCheck );

			if( valueToCheck is Char )
				return IsNull( (Char)valueToCheck );

			if( valueToCheck is Byte )
				return IsNull( (Byte)valueToCheck );

			if( valueToCheck is char[] )
				return IsNull( (char[])valueToCheck );

			if( valueToCheck is Guid )
				return IsNull( (Guid)valueToCheck );

			return false;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="613"> 
		///		<ExpectedInput>Int32.MinValue</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="614"> 
		///		<ExpectedInput>Int32.MaxValue</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsNull
		/// </summary>
		/// <param name="valueToCheck"></param>
		/// <returns></returns>
		public static bool IsNull( Int32 valueToCheck )
		{
			return valueToCheck == Int32Null;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="615"> 
		///		<ExpectedInput>DateTime.MinValue</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="616"> 
		///		<ExpectedInput>DateTime.Now</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsNull
		/// </summary>
		/// <param name="valueToCheck"></param>
		/// <returns></returns>
		public static bool IsNull( DateTime valueToCheck )
		{
			return valueToCheck == DateTimeNull;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="617"> 
		///		<ExpectedInput>Char.MinValue</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="618"> 
		///		<ExpectedInput>'A'</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsNull
		/// </summary>
		/// <param name="valueToCheck"></param>
		/// <returns></returns>
		public static bool IsNull( Char valueToCheck )
		{
			return valueToCheck == CharNull;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="619"> 
		///		<ExpectedInput>Byte.MaxValue</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="620"> 
		///		<ExpectedInput>Byte.MinValue</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsNull
		/// </summary>
		/// <param name="valueToCheck"></param>
		/// <returns></returns>
		public static bool IsNull( Byte valueToCheck )
		{
			return valueToCheck == ByteNull;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="621"> 
		///		<ExpectedInput>Empty CharArray</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="622"> 
		///		<ExpectedInput>CharArray</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsNull
		/// </summary>
		/// <param name="valueToCheck"></param>
		/// <returns></returns>
		public static bool IsNull( char[] valueToCheck )
		{
			return valueToCheck == null || valueToCheck.Length == 0;
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/16/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4997"> 
		///		<ExpectedInput>Guid.Empty</ExpectedInput>
		///		<ExpectedOutput>True</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4998"> 
		///		<ExpectedInput>GUID</ExpectedInput>
		///		<ExpectedOutput>False</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///<summary>Tests GUID for nulls.</summary>
		///<param name="valueToCheck"></param>
		///<returns></returns>
		public static bool IsNull( Guid valueToCheck ) 
		{
			return valueToCheck == GuidNull;
		}
	}
	#endregion



	#region StDbNullConvert Class
	/// <summary>
	/// StDbNullConvert - all static methods
	/// </summary>
	public abstract class StDbNullConvert
	{

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="623"> 
		///		<ExpectedInput>Sting</ExpectedInput>
		///		<ExpectedOutput>String</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="624"> 
		///		<ExpectedInput>Int32.MinValue</ExpectedInput>
		///		<ExpectedOutput>null</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToString
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static string ToString( object valueToConvert )
		{
			return StNullConvert.IsNull( valueToConvert ) ? null : (string)valueToConvert;
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/22/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5019"> 
		///		<ExpectedInput>Valid object convertable to Int32.</ExpectedInput>
		///		<ExpectedOutput>Converted value.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5020"> 
		///		<ExpectedInput>Object that can't be converted to Int32.</ExpectedInput>
		///		<ExpectedOutput>FormatException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Converts supplied object to Int32, substituting NULL with provided value.
		/// </summary>
		/// <param name="valueToConvert">Object to convert.</param>
		/// <param name="nullSubstitute">Value to use if the object is evaluated to NULL.</param>
		/// <returns>Converted value.</returns>
		public static Int32 ToInt32( object valueToConvert, Int32 nullSubstitute )
		{
			return StNullConvert.IsNull( valueToConvert ) ? nullSubstitute : Convert.ToInt32( valueToConvert );
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="625"> 
		///		<ExpectedInput>Int32.MaxValue</ExpectedInput>
		///		<ExpectedOutput>Int32 value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="626"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>Int32.MinValue</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToInt32
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static Int32 ToInt32( object valueToConvert )
		{
			return ToInt32( valueToConvert, StNullConvert.Int32Null );
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="627"> 
		///		<ExpectedInput>DateTime.Now</ExpectedInput>
		///		<ExpectedOutput>DateTime value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="628"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>DateTime.MinValue</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToDateTime
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static DateTime ToDateTime( object valueToConvert )
		{
			return StNullConvert.IsNull( valueToConvert ) ? StNullConvert.DateTimeNull : (DateTime)valueToConvert;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="629"> 
		///		<ExpectedInput>IPAddress.Broadcast</ExpectedInput>
		///		<ExpectedOutput>IPAddress value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="630"> 
		///		<ExpectedInput>Int32.MinValue</ExpectedInput>
		///		<ExpectedOutput>null</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToIPAddress
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static IPAddress ToIPAddress( object valueToConvert )
		{
			return StNullConvert.IsNull( valueToConvert ) ? null : IPAddress.Parse( valueToConvert.ToString().Trim() );
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="631"> 
		///		<ExpectedInput>'A'</ExpectedInput>
		///		<ExpectedOutput>char value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="632"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>Char.MinValue</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToChar
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static Char ToChar( object valueToConvert )
		{
			return StNullConvert.IsNull( valueToConvert ) ? StNullConvert.CharNull : Convert.ToChar( valueToConvert );
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="633"> 
		///		<ExpectedInput>Byte.MinValue</ExpectedInput>
		///		<ExpectedOutput>byte value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="634"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>Byte.MaxValue</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToByte
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static Byte ToByte( object valueToConvert )
		{
			return StNullConvert.IsNull( valueToConvert ) ? StNullConvert.ByteNull : (Byte)valueToConvert;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="637"> 
		///		<ExpectedInput>Valid CharArray</ExpectedInput>
		///		<ExpectedOutput>char array value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="641"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>Empty CharArray</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToCharArray
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static char[] ToCharArray( object valueToConvert )
		{
			return StNullConvert.IsNull( valueToConvert ) ? String.Empty.ToCharArray() : valueToConvert.ToString().ToCharArray();
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/16/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4999"> 
		///		<ExpectedInput>Valid GUID as object.</ExpectedInput>
		///		<ExpectedOutput>Valid GUID matching the input.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5000"> 
		///		<ExpectedInput>DbNull</ExpectedInput>
		///		<ExpectedOutput>Guid.Empty</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Converts supplied object to GUID if it's convertable.
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static Guid ToGuid( object valueToConvert ) 
		{
			return StNullConvert.IsNull( valueToConvert ) ? StNullConvert.GuidNull : (Guid)valueToConvert;
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5940"> 
		///		<ExpectedInput>Valid rowversion (byte[]) as object.</ExpectedInput>
		///		<ExpectedOutput>Valid rowversion (byte[]) matching the input.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5941"> 
		///		<ExpectedInput>DbNull</ExpectedInput>
		///		<ExpectedOutput>null</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Converts rowversion value from DB to byte[].
		/// </summary>
		/// <param name="valueToConvert">DB value to treat as rowversion.</param>
		/// <returns>DB rowversion converted to byte[].</returns>
		public static byte[] ToRowversion( object valueToConvert )
		{			
			return StNullConvert.IsNull( valueToConvert ) ? StNullConvert.RowversionNull : (byte[])valueToConvert;
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/29/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5072"> 
		///		<ExpectedInput>Bool 'true' cast as object.</ExpectedInput>
		///		<ExpectedOutput>True.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5073"> 
		///		<ExpectedInput>String.</ExpectedInput>
		///		<ExpectedOutput>InvalidCastException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Converts supplied object to boolean substituting null with supplied value.
		/// </summary>
		/// <param name="valueToConvert">Value to convert.</param>
		/// <param name="nullSubstitute">Substitute for null/dbnull.</param>
		/// <returns>Converted boolean value.</returns>
		public static bool ToBool( object valueToConvert, bool nullSubstitute )
		{
			return StNullConvert.IsNull( valueToConvert ) ? nullSubstitute : (bool)valueToConvert; 
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="648"> 
		///		<ExpectedInput>Object</ExpectedInput>
		///		<ExpectedOutput>object value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="650"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// From
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static object From( object valueToConvert )
		{
			if( StNullConvert.IsNull( valueToConvert ) )
				return System.DBNull.Value;

			if( valueToConvert is IPAddress )
				return valueToConvert.ToString();

			if( valueToConvert is char[] )
				return ConvertFromCharArray( (char[])valueToConvert );

			return valueToConvert;
		}

		private static object ConvertFromCharArray( char[] valueToConvert )
		{
			if( StNullConvert.IsNull( valueToConvert ) )
				return DBNull.Value;
			else
				return new StringBuilder( ((char[])valueToConvert).Length ).Append( (char[])valueToConvert ).ToString();
		}
	}
	#endregion


	#region StUiNullConvert Class

	/// <summary>
	/// StUiNullConvert - all static methods
	/// </summary>
	public abstract class StUiNullConvert
	{	
		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="651"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>decimal value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="652"> 
		///		<ExpectedInput>decimal</ExpectedInput>
		///		<ExpectedOutput>decimal</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DecimalFrom
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <param name="nullSubstitute"></param>
		/// <returns></returns>
		public static decimal DecimalFrom( object valueToConvert, decimal nullSubstitute )
		{
			if( StNullConvert.IsNull( valueToConvert ) )
				return nullSubstitute;
			
			return Convert.ToDecimal( valueToConvert );
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="653"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="654"> 
		///		<ExpectedInput>null</ExpectedInput>
		///		<ExpectedOutput>empty string</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// From
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static string From( object valueToConvert )
		{
			if( StNullConvert.IsNull( valueToConvert ) )
				return String.Empty;

			return valueToConvert.ToString();
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="655"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>int32 value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="656"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToInt32
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static Int32 ToInt32( string valueToConvert )
		{
			if( IsZeroString( valueToConvert ) )
				return StNullConvert.Int32Null;

			double _result;

			if( !Double.TryParse( valueToConvert, NumberStyles.Integer, NumberFormatInfo.InvariantInfo, out _result ) )
				return StNullConvert.Int32Null;
			
			checked
			{
				return (Int32)_result;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="657"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>IPAddress value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="665"> 
		///		<ExpectedInput>Empty String</ExpectedInput>
		///		<ExpectedOutput>null</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToIPAddress
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static IPAddress ToIPAddress( string valueToConvert )
		{
			return IsZeroString( valueToConvert ) ? null : IPAddress.Parse( valueToConvert );
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="666"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>char value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="667"> 
		///		<ExpectedInput>empty string</ExpectedInput>
		///		<ExpectedOutput>Char.MinValue</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToChar
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static Char ToChar( string valueToConvert )
		{
			return IsZeroString( valueToConvert ) ? StNullConvert.CharNull : Convert.ToChar( valueToConvert );
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="671"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>String value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="672"> 
		///		<ExpectedInput>empty string</ExpectedInput>
		///		<ExpectedOutput>null</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// ToString
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <param name="nullifyIfEmpty"></param>
		/// <returns></returns>
		public static string ToString( string valueToConvert, bool nullifyIfEmpty )
		{
			return IsZeroString( valueToConvert ) && nullifyIfEmpty ? null : valueToConvert;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="686"> 
		///		<ExpectedInput>decimal</ExpectedInput>
		///		<ExpectedOutput>int32 value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="687"> 
		///		<ExpectedInput>Decimal.MaxValue</ExpectedInput>
		///		<ExpectedOutput>Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DecimalToInt32
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static Int32 DecimalToInt32( decimal valueToConvert )
		{
			checked
			{
				return Convert.ToInt32( valueToConvert );
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="688"> 
		///		<ExpectedInput>Decimal</ExpectedInput>
		///		<ExpectedOutput>byte value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="689"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DecimalToByte
		/// </summary>
		/// <param name="valueToConvert"></param>
		/// <returns></returns>
		public static Byte DecimalToByte( decimal valueToConvert )
		{
			checked
			{
				return Convert.ToByte( valueToConvert );
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="690"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>false</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="691"> 
		///		<ExpectedInput>empty string</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// IsZeroString
		/// </summary>
		/// <param name="stringToCheck"></param>
		/// <returns></returns>
		public static bool IsZeroString( string stringToCheck )
		{
			return ( stringToCheck == null || stringToCheck.Trim() == String.Empty );
		}
	}
	#endregion
}
